function [r1,r2]  = ncor2(x,y)
% ncor2 compute the nCor and nCor_|\Delta| between x and y
%    x has N rows and M columns and y has N rows and one columns
%    r1 and r2 respectively denotes the nCor and nCor_|\Delta| scores

% Check the sizes of x and y 
if size(x,1) ~= size(y,1)
    error('x and y must have the same number of rows')
elseif size(y,2) > 1
    error('y must have one column')
end

% Normalize x before computing distance matrix
if size(x,2)>1
    for i = 1:size(x,2)
        x(:,i) = x(:,i)-mean(x(:,i));
        x(:,i) = x(:,i)/std(x(:,i));
    end
end

% Generate permutation using order statistics or NN algorithm
if size(x,2)>1
    dis = squareform(pdist(x));
    perm = computePerm(dis,1);
else
    [~,perm] = sort(x);
end

% Compute the correlation values
y = y(perm);
temp = corrcoef(y(1:end-1),y(2:end));
r1 = temp(1,2); % nCor
y1 = abs(y(2:end-2)-y(1:end-3));
y2 = abs(y(4:end)-y(3:end-1));
temp = corrcoef(y1,y2);
r2 = temp(1,2); % nCor_|\Delta|

%---------------------------------------------
function perm = computePerm(dis,intK)
% Generate permutation using  NN algorithm
p =1;
perm = intK+zeros(1,ceil(p*length(dis)));
N = 1:length(dis);
N(intK) = [];
for i = 2:length(perm)
    [~,temp] =  min(dis(perm(i-1),N));
    perm(i) = N(temp);
    N(temp) = [];
end
